/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken;

import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authtoken.RequestedPrivileges;
import com.floragunn.searchguard.authz.ActionAuthorization;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.PrivilegesEvaluationResult;
import com.floragunn.searchguard.authz.RoleBasedActionAuthorization;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.authz.actions.ActionRequestIntrospector;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.authz.config.ActionGroup;
import java.util.Set;

public class RestrictedActionAuthorization
implements ActionAuthorization {
    private final ActionAuthorization base;
    private final ActionAuthorization restrictionSgRoles;
    private final RequestedPrivileges restriction;

    RestrictedActionAuthorization(ActionAuthorization base, RequestedPrivileges restriction, ActionGroup.FlattenedIndex actionGroups, Actions actions, Set<String> indices, Set<String> tenants) {
        this.base = base;
        this.restriction = restriction;
        this.restrictionSgRoles = new RoleBasedActionAuthorization(restriction.toRolesConfig(), actionGroups, actions, indices, tenants);
    }

    public PrivilegesEvaluationResult hasClusterPermission(PrivilegesEvaluationContext context, Action action) throws PrivilegesEvaluationException {
        PrivilegesEvaluationResult result = this.restrictionSgRoles.hasClusterPermission(context.mappedRoles(RequestedPrivileges.RESTRICTION_ROLES), action);
        if (result.getStatus() != PrivilegesEvaluationResult.Status.OK) {
            return result.reason("Privilege was not requested for token");
        }
        return this.base.hasClusterPermission(context, action);
    }

    public PrivilegesEvaluationResult hasIndexPermission(PrivilegesEvaluationContext context, ImmutableSet<Action> actions, ActionRequestIntrospector.ResolvedIndices resolvedIndices) throws PrivilegesEvaluationException {
        PrivilegesEvaluationResult restrictedPermission = this.restrictionSgRoles.hasIndexPermission(context.mappedRoles(RequestedPrivileges.RESTRICTION_ROLES), actions, resolvedIndices);
        if (restrictedPermission.getStatus() != PrivilegesEvaluationResult.Status.OK) {
            return restrictedPermission.reason("Privilege was not requested for token");
        }
        return this.base.hasIndexPermission(context, actions, resolvedIndices);
    }

    public PrivilegesEvaluationResult hasTenantPermission(PrivilegesEvaluationContext context, Action action, String requestedTenant) throws PrivilegesEvaluationException {
        PrivilegesEvaluationResult result = this.restrictionSgRoles.hasTenantPermission(context.mappedRoles(RequestedPrivileges.RESTRICTION_ROLES), action, requestedTenant);
        if (result.getStatus() != PrivilegesEvaluationResult.Status.OK) {
            return result.reason("Privilege was not requested for token");
        }
        return this.base.hasTenantPermission(context, action, requestedTenant);
    }

    public String toString() {
        return "RestrictedActionAuthorization [base=" + this.base + ", restrictionSgRoles=" + this.restrictionSgRoles + ", restriction=" + this.restriction + "]";
    }
}

